/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.api.common.data.IHandState;
import dev.toma.gunsrpg.api.common.data.IJamInfo;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.client.animation.ModAnimations;
import dev.toma.gunsrpg.common.item.guns.setup.AbstractGun;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.IAnimationPipeline;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class JamInfo
implements IJamInfo,
IPlayerCapEntry {
    private final IHandState handState;
    private final PlayerEntity player;
    private IPlayerCapEntry.IClientSynchReq syncRequestFactory = () -> {};
    private boolean unjamming;
    private int activeSlot;
    private int remainingTime;

    public JamInfo(IHandState handState, PlayerEntity player) {
        this.handState = handState;
        this.player = player;
    }

    @Override
    public void startUnjamming(int slot, int time) {
        this.handState.setHandsBusy();
        this.activeSlot = slot;
        this.remainingTime = time;
        this.setUnjamming(true);
        this.syncRequestFactory.makeSyncRequest();
    }

    @Override
    public void tick() {
        if (this.unjamming) {
            if (--this.remainingTime <= 0) {
                this.completeUnjamming();
            } else if (this.player.field_71071_by.field_70461_c != this.activeSlot) {
                this.interruptUnjam();
                if (this.player.field_70170_p.field_72995_K) {
                    this.interruptAnimation();
                }
            }
        }
    }

    @Override
    public boolean isUnjamming() {
        return this.unjamming;
    }

    @Override
    public void setUnjamming(boolean unjamming) {
        this.unjamming = unjamming;
    }

    @Override
    public int getFlag() {
        return 64;
    }

    @Override
    public void toNbt(CompoundNBT cnbt) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("unjamming", this.unjamming);
        nbt.func_74768_a("slot", this.activeSlot);
        nbt.func_74768_a("remainingTime", this.remainingTime);
        cnbt.func_218657_a("jamInfo", (INBT)nbt);
    }

    @Override
    public void fromNbt(CompoundNBT cnbt) {
        CompoundNBT nbt = cnbt.func_150297_b("jamInfo", 10) ? cnbt.func_74775_l("jamInfo") : new CompoundNBT();
        this.unjamming = nbt.func_74767_n("unjamming");
        this.activeSlot = nbt.func_74762_e("slot");
        this.remainingTime = nbt.func_74762_e("remainingTime");
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.syncRequestFactory = request;
    }

    private void completeUnjamming() {
        this.interruptUnjam();
        ItemStack stack = this.player.func_184614_ca();
        if (stack.func_77973_b() instanceof AbstractGun) {
            AbstractGun gun = (AbstractGun)stack.func_77973_b();
            gun.setJammedState(stack, false);
        }
    }

    private void interruptUnjam() {
        this.setUnjamming(false);
        this.handState.freeHands();
        this.syncRequestFactory.makeSyncRequest();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void interruptAnimation() {
        IAnimationPipeline pipeline = AnimationEngine.get().pipeline();
        pipeline.remove(ModAnimations.UNJAM);
    }
}

